/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.RuntimeDroolsException;
import org.drools.runtime.process.EventListener;
import org.drools.runtime.process.NodeInstance;
import org.drools.time.TimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.timer.TimerInstance;
import org.jbpm.process.instance.timer.TimerManager;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.node.StateBasedNode;
import org.jbpm.workflow.instance.impl.ExtendedNodeInstanceImpl;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.node.EventBasedNodeInstanceInterface;
import org.mvel2.MVEL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StateBasedNodeInstance
extends ExtendedNodeInstanceImpl
implements EventBasedNodeInstanceInterface,
EventListener {
    private static final long serialVersionUID = 510L;
    private static final Pattern PARAMETER_MATCHER = Pattern.compile("#\\{(\\S+)\\}", 32);
    private List<Long> timerInstances;

    public StateBasedNode getEventBasedNode() {
        return (StateBasedNode)this.getNode();
    }

    @Override
    public void internalTrigger(NodeInstance from, String type) {
        super.internalTrigger(from, type);
        Map<Timer, DroolsAction> timers = this.getEventBasedNode().getTimers();
        if (timers != null) {
            this.addTimerListener();
            this.timerInstances = new ArrayList<Long>(timers.size());
            TimerManager timerManager = ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getTimerManager();
            for (Timer timer : timers.keySet()) {
                TimerInstance timerInstance = this.createTimerInstance(timer);
                timerManager.registerTimer(timerInstance, this.getProcessInstance());
                this.timerInstances.add(timerInstance.getId());
            }
        }
    }

    protected TimerInstance createTimerInstance(Timer timer) {
        TimerInstance timerInstance = new TimerInstance();
        timerInstance.setDelay(this.resolveValue(timer.getDelay()));
        if (timer.getPeriod() == null) {
            timerInstance.setPeriod(0L);
        } else {
            timerInstance.setPeriod(this.resolveValue(timer.getPeriod()));
        }
        timerInstance.setTimerId(timer.getId());
        return timerInstance;
    }

    private long resolveValue(String s) {
        try {
            return TimeUtils.parseTimeString(s);
        }
        catch (RuntimeDroolsException e) {
            HashMap<String, String> replacements = new HashMap<String, String>();
            Matcher matcher = PARAMETER_MATCHER.matcher(s);
            while (matcher.find()) {
                String variableValueString;
                Object variableValue;
                String paramName = matcher.group(1);
                if (replacements.get(paramName) != null) continue;
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", paramName);
                if (variableScopeInstance != null) {
                    variableValue = variableScopeInstance.getVariable(paramName);
                    variableValueString = variableValue == null ? "" : variableValue.toString();
                    replacements.put(paramName, variableValueString);
                    continue;
                }
                try {
                    variableValue = MVEL.eval(paramName, new NodeInstanceResolverFactory(this));
                    variableValueString = variableValue == null ? "" : variableValue.toString();
                    replacements.put(paramName, variableValueString);
                }
                catch (Throwable t) {
                    System.err.println("Could not find variable scope for variable " + paramName);
                    System.err.println("when trying to replace variable in processId for sub process " + this.getNodeName());
                    System.err.println("Continuing without setting process id.");
                }
            }
            for (Map.Entry replacement : replacements.entrySet()) {
                s = s.replace("#{" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
            }
            return TimeUtils.parseTimeString(s);
        }
    }

    @Override
    public void signalEvent(String type, Object event) {
        TimerInstance timerInstance;
        if ("timerTriggered".equals(type) && this.timerInstances.contains((timerInstance = (TimerInstance)event).getId())) {
            this.triggerTimer(timerInstance);
        }
    }

    private void triggerTimer(TimerInstance timerInstance) {
        for (Map.Entry<Timer, DroolsAction> entry : this.getEventBasedNode().getTimers().entrySet()) {
            if (entry.getKey().getId() != timerInstance.getTimerId()) continue;
            this.executeAction(entry.getValue());
            return;
        }
    }

    @Override
    public String[] getEventTypes() {
        return new String[]{"timerTriggered"};
    }

    public void triggerCompleted() {
        this.triggerCompleted("DROOLS_DEFAULT", true);
    }

    @Override
    public void addEventListeners() {
        if (this.timerInstances != null && this.timerInstances.size() > 0) {
            this.addTimerListener();
        }
    }

    protected void addTimerListener() {
        this.getProcessInstance().addEventListener("timerTriggered", this, false);
    }

    @Override
    public void removeEventListeners() {
        this.getProcessInstance().removeEventListener("timerTriggered", this, false);
    }

    @Override
    protected void triggerCompleted(String type, boolean remove) {
        this.cancelTimers();
        super.triggerCompleted(type, remove);
    }

    public List<Long> getTimerInstances() {
        return this.timerInstances;
    }

    public void internalSetTimerInstances(List<Long> timerInstances) {
        this.timerInstances = timerInstances;
    }

    @Override
    public void cancel() {
        this.cancelTimers();
        this.removeEventListeners();
        super.cancel();
    }

    private void cancelTimers() {
        if (this.timerInstances != null) {
            TimerManager timerManager = ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getTimerManager();
            for (Long id : this.timerInstances) {
                timerManager.cancelTimer(id);
            }
        }
    }
}

